import logging

from cars.core.daemons import CarsharingDaemon
from ..core.ban_manager import BanManager


LOGGER = logging.getLogger(__name__)


class BanManagerDaemon(CarsharingDaemon):

    tick_interval = '* * * * * */15'

    def get_distributed_lock_relative_path(self):
        return 'bans/locks/ban_manager.lock'

    def get_solomon_sensor_prefix(self):
        return 'bans.ban_manager'

    def get_solomon_service(self):
        return 'bans'

    def _do_tick(self):
        ban_manager = BanManager.from_settings()
        ban_manager.try_unblock_all()
