import enum

from django.db import models

from cars.users.models.user import User


class Ban(models.Model):

    class Reason(enum.Enum):
        AUTO = 'blocked_auto'
        DRIVING_BAN = 'blocked_driving_ban'
        DUPLICATE_LICENSE = 'blocked_duplicate_driver_license'
        DUPLICATE_PASSPORT = 'blocked_duplicate_namber_pass'
        OLD_LICENSE = 'old_license'
        SPEED_ASSHOLE = 'speed_asshole'
        TOO_OLD = 'too_old'
        OTHER = 'blocked_other'

    user = models.ForeignKey(
        User,
        on_delete=models.CASCADE,
        related_name='bans',
    )

    started_by = models.ForeignKey(
        User,
        on_delete=models.CASCADE,
        related_name='created_bans',
        null=True,
    )
    finished_by = models.ForeignKey(
        User,
        on_delete=models.CASCADE,
        related_name='finished_bans',
        null=True,
    )

    started_at = models.DateTimeField()
    finished_at = models.DateTimeField(null=True)

    reason = models.CharField(
        max_length=32,
        choices=[(x.value, x.name) for x in Reason],
        default=Reason.OTHER.value,
    )
    comment = models.TextField(null=True)

    class Meta:
        db_table = 'ban'
        indexes = [
            models.Index(
                fields=['started_at'],
                name='ban_started_at_idx',
            ),
            models.Index(
                fields=['finished_at'],
                name='ban_finished_at_idx',
            ),
            models.Index(
                fields=['reason'],
                name='ban_reason_idx',
            ),
        ]

    def get_reason(self):
        return self.Reason(self.reason)
