import cars.settings
from cars.core.push_client import CarsharingPushClientLogger
from cars.django.lock import UwsgiLock


class BillingPushClientLogger(CarsharingPushClientLogger):

    def __init__(self, filename):
        super().__init__(filename=filename, lock=UwsgiLock())

    def log(self, type_, data):
        type_ = 'billing.{}'.format(type_)
        super().log(type_=type_, data=data)


PUSH_CLIENT = BillingPushClientLogger(filename=cars.settings.BILLING['push_client']['filename'])
