import cars.settings
from cars.core.daemons import CarsharingDaemon
from ..core.payment_processor import PaymentProcessor
from ..core.push_client import PUSH_CLIENT


class PaymentProcessorDaemon(CarsharingDaemon):

    tick_interval = cars.settings.BILLING['payment_processor_tick_interval']

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self.processor = PaymentProcessor.from_settings(push_client=PUSH_CLIENT)

    def get_distributed_lock_relative_path(self):
        return 'billing/locks/payment_processor.lock'

    def get_solomon_sensor_prefix(self):
        return 'daemons.payment_processor'

    def get_solomon_service(self):
        return cars.settings.BILLING['solomon']['service']

    def _do_tick(self):
        self.processor.process_all()
