import datetime

import pytz
from factory import SubFactory
from factory.django import DjangoModelFactory
from factory.fuzzy import FuzzyDateTime, FuzzyDecimal, FuzzyText

from cars.users.factories.user import UserFactory
from ..models.card_payment import CardPayment


class CardPaymentFactory(DjangoModelFactory):

    class Meta:
        model = CardPayment

    user = SubFactory(UserFactory)
    amount = FuzzyDecimal(low=1, high=100)
    status = CardPayment.Status.DRAFT.value
    paymethod_id = FuzzyText(length=8)
    purchase_token = None

    created_at = FuzzyDateTime(datetime.datetime(2017, 1, 1, tzinfo=pytz.UTC))
    updated_at = FuzzyDateTime(datetime.datetime(2017, 1, 1, tzinfo=pytz.UTC))
    started_at = None
    completed_at = None
