import enum


class IPayment:

    class GenericStatus(enum.Enum):
        IN_PROGRESS = 'in_progress'
        SUCCESS = 'success'
        ERROR = 'error'
        REFUNDED = 'refunded'

    def get_amount(self):
        raise NotImplementedError

    def get_generic_status(self):
        raise NotImplementedError

    def is_error(self):
        return self.get_generic_status() is self.GenericStatus.ERROR
