# -*- coding: utf-8 -*-
# Generated by Django 1.11.6 on 2018-02-03 22:34
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='CardPayment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('amount', models.DecimalField(decimal_places=2, max_digits=10)),
                ('status', models.CharField(choices=[('draft', 'DRAFT'), ('not_started', 'NOT_STARTED'), ('started', 'STARTED'), ('authorized', 'AUTHORIZED'), ('not_authorized', 'NOT_AUTHORIZED'), ('in_progress', 'IN_PROGRESS'), ('success', 'SUCCESS'), ('unhold', 'UNHOLD')], default='draft', max_length=16)),
                ('paymethod_id', models.CharField(max_length=32)),
                ('purchase_token', models.CharField(max_length=32, null=True)),
                ('resp_code', models.CharField(max_length=32, null=True)),
                ('resp_desc', models.CharField(max_length=128, null=True)),
                ('created_at', models.DateTimeField()),
                ('updated_at', models.DateTimeField()),
                ('started_at', models.DateTimeField(null=True)),
                ('cleared_at', models.DateTimeField(null=True)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'billing_card_payment',
            },
        ),
        migrations.AddIndex(
            model_name='cardpayment',
            index=models.Index(fields=['user'], name='billing_card_payment_user_idx'),
        ),
        migrations.AddIndex(
            model_name='cardpayment',
            index=models.Index(fields=['status'], name='billing_card_payment_status_idx'),
        ),
    ]
