# -*- coding: utf-8 -*-
# Generated by Django 1.11.6 on 2018-02-18 18:19
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django_db_constraints.operations


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('billing', '0003_card_payment_orig_amount'),
    ]

    operations = [
        migrations.CreateModel(
            name='BonusAccount',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('balance', models.DecimalField(decimal_places=2, default=0, max_digits=10)),
                ('registration_taxi_cashback_earned', models.DecimalField(decimal_places=2, default=0, max_digits=10)),
                ('registration_taxi_cashback_spent', models.DecimalField(decimal_places=2, default=0, max_digits=10)),
                ('user', models.OneToOneField(db_index=False, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'billing_bonus_account',
            },
        ),
        migrations.AddIndex(
            model_name='bonusaccount',
            index=models.Index(fields=['user'], name='billing_bonus_account_user_idx'),
        ),
        django_db_constraints.operations.AlterConstraints(
            name='BonusAccount',
            db_constraints={'balance_check': '\n                CHECK (\n                  (balance = registration_taxi_cashback_earned - registration_taxi_cashback_spent)\n                  AND\n                  (registration_taxi_cashback_earned >= registration_taxi_cashback_spent)\n                )\n                '},
        ),
    ]
