# -*- coding: utf-8 -*-
# Generated by Django 1.11.6 on 2018-02-22 16:46
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django_db_constraints.operations


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('billing', '0005_bonus_payment'),
    ]

    operations = [
        migrations.CreateModel(
            name='BonusAccountOperation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField()),
                ('amount', models.DecimalField(decimal_places=2, max_digits=10)),
                ('balance', models.DecimalField(decimal_places=2, max_digits=10)),
                ('nonce', models.CharField(max_length=64)),
            ],
            options={
                'db_table': 'billing_bonus_account_operation',
            },
        ),
        migrations.AddField(
            model_name='bonusaccount',
            name='generic_earned',
            field=models.DecimalField(decimal_places=2, default=0, max_digits=10),
        ),
        migrations.AddField(
            model_name='bonusaccount',
            name='generic_spent',
            field=models.DecimalField(decimal_places=2, default=0, max_digits=10),
        ),
        migrations.AddField(
            model_name='bonusaccountoperation',
            name='bonus_account',
            field=models.ForeignKey(db_index=False, on_delete=django.db.models.deletion.CASCADE, related_name='operations', to='billing.BonusAccount'),
        ),
        migrations.AddField(
            model_name='bonusaccountoperation',
            name='created_by',
            field=models.ForeignKey(db_index=False, on_delete=django.db.models.deletion.CASCADE, related_name='created_bonus_account_operations', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddIndex(
            model_name='bonusaccountoperation',
            index=models.Index(fields=['bonus_account'], name='billing_bonus_account_operation_bonus_account_idx'),
        ),
        migrations.AddIndex(
            model_name='bonusaccountoperation',
            index=models.Index(fields=['created_at'], name='billing_bonus_account_operation_created_at_idx'),
        ),
        migrations.AddIndex(
            model_name='bonusaccountoperation',
            index=models.Index(fields=['created_by'], name='billing_bonus_account_operation_created_by_idx'),
        ),
        django_db_constraints.operations.AlterConstraints(
            name='bonusaccount',
            db_constraints={'balance_check': '\n                CHECK (\n                  (\n                    balance =\n                      registration_taxi_cashback_earned - registration_taxi_cashback_spent\n                      + generic_earned - generic_spent\n                  )\n                  AND\n                  (registration_taxi_cashback_earned >= registration_taxi_cashback_spent)\n                  AND\n                  (generic_earned >= generic_spent)\n                )\n                '},
        ),
    ]
