from django.db import models

from cars.users.models.user import User
from ..iface.payment import IPayment


class BonusPayment(IPayment, models.Model):

    user = models.ForeignKey(
        User,
        related_name='bonus_payments',
        on_delete=models.CASCADE,
        db_index=False,
    )
    amount = models.DecimalField(max_digits=10, decimal_places=2)
    created_at = models.DateTimeField(null=True)

    class Meta:
        db_table = 'billing_bonus_payment'
        indexes = [
            models.Index(
                fields=['user'],
                name='billing_bonus_payment_user_idx',
            ),
        ]

    def __str__(self):
        return '<BonusPayment: amount={}, created_at={}>'.format(self.amount, self.created_at)

    def get_amount(self):
        return self.amount

    def get_generic_status(self):
        return self.GenericStatus.SUCCESS
