from django.db import models
from cars.users.models.user import User


class RefundIssuesHistory(models.Model):
    history_event_id = models.IntegerField(primary_key=True)
    history_user = models.ForeignKey(
        User,
        on_delete=models.CASCADE,
        related_name='refund_issues_history_history_user',
    )
    history_action = models.TextField()
    history_timestamp = models.BigIntegerField()
    history_comment = models.TextField(null=True)
    history_originator_id = models.TextField(null=True)
    session_id = models.TextField()
    payment_id = models.TextField()
    user = models.ForeignKey(
        User,
        on_delete=models.CASCADE,
        related_name='refund_issues_history_user',
    )
    sum = models.IntegerField(default=0)

    class Meta:
        managed = False
        db_table = 'refund_issues_history'
