# -*- coding: utf-8 -*-

from django.db import models

from cars.users.models.user import User


class Task(models.Model):
    session_id = models.TextField(primary_key=True)
    billing_type = models.TextField()
    user = models.ForeignKey(
        User,
        on_delete=models.CASCADE,
    )
    bill = models.FloatField(default=0)
    deposit = models.IntegerField(default=0)
    payment_status = models.TextField(default='not_started')
    last_status_update = models.IntegerField(default=0)
    task_status = models.TextField(default='not_started')
    state = models.TextField(default='active')
    available_bonus = models.IntegerField(default=0)
    discretization = models.IntegerField(default=0)
    last_payment_update = models.IntegerField(default=0)
    queue = models.TextField(default='active')
    next_queue = models.TextField(default='active')

    class Meta:
        managed = False
        db_table = 'billing_tasks'


class TasksHistory(models.Model):
    history_event_id = models.IntegerField(primary_key=True)
    history_user = models.ForeignKey(
        User,
        on_delete=models.CASCADE,
    )
    history_action = models.TextField()
    history_timestamp = models.BigIntegerField()
    history_comment = models.TextField()
    session_id = models.TextField()
    billing_type = models.TextField()
    user_id = models.TextField()
    bill = models.FloatField()
    deposit = models.IntegerField()
    state = models.TextField()
    payment_status = models.TextField()
    task_status = models.TextField()
    last_status_update = models.IntegerField()
    available_bonus = models.IntegerField()
    discretization = models.IntegerField()
    history_originator_id = models.TextField()
    next_queue = models.TextField()
    queue = models.TextField()

    class Meta:
        managed = False
        db_table = 'billing_tasks_history'
