from django.shortcuts import get_object_or_404
from rest_framework.response import Response

from cars.django.util import ReqAnsLogger
from cars.django.views import CarsharingAPIView
from ..core.payment_processor import CardPaymentProcessor
from ..core.push_client import PUSH_CLIENT
from ..models.card_payment import CardPayment
from ..serializers.trust_notify import TrustNotifyArgumentsSerializer


class TrustNotifyView(CarsharingAPIView):

    arguments_serializer_class = TrustNotifyArgumentsSerializer
    reqans_logger_policy = ReqAnsLogger.Policy.FULL

    payment_processor = CardPaymentProcessor.from_settings(push_client=PUSH_CLIENT)

    def do_post(self, request):
        purchase_token = request.arguments.get('purchase_token')
        if purchase_token is not None:
            payment = get_object_or_404(
                CardPayment.objects.select_related('user'),
                purchase_token=purchase_token,
            )
            self.payment_processor.sync_payment(payment)
        return Response()
