from rest_framework.response import Response

from cars.carsharing.core.tariff_manager import CarsharingTariffManager
from cars.django.views import CarsharingAPIView
from ..serializers.carsharing_base import (
    CarsharingBaseArgumentsSerializer, CarsharingBaseTariffSerializer,
)


class CarsharingBaseView(CarsharingAPIView):

    arguments_serializer_class = CarsharingBaseArgumentsSerializer

    _tariff_manager = None

    @classmethod
    def get_tariff_manager(cls):
        if cls._tariff_manager is None:
            cls._tariff_manager = CarsharingTariffManager.from_settings()
        return cls._tariff_manager

    def do_post(self, request):
        tariffs = self.get_tariff_manager().pick_tariff(requests=request.arguments['requests'])
        data = {
            'results': [
                CarsharingBaseTariffSerializer(tariff).data
                for tariff in tariffs
            ],
        }
        return Response(data)
