import datetime

from django.utils import timezone
from rest_framework.exceptions import NotFound, ParseError, PermissionDenied

import cars.settings
from cars.users.models import User
from ..models import CallcenterUserLink


class CallcenterLinkManager:

    def create_request_link(self, requester_uid):
        created_at = timezone.now()
        available_until = created_at + datetime.timedelta(
            seconds=cars.settings.CALLCENTER['user_link_ttl']
        )

        requester = User.objects.filter(uid=requester_uid).first()
        if requester is None:
            return None, 'uid.unknown'

        acl = cars.settings.CALLCENTER['acl']
        if acl is not None and requester_uid not in acl:
            raise PermissionDenied

        request = CallcenterUserLink(
            created_at=created_at,
            available_until=available_until,
            requester=requester,
        )
        return request, None

    def register_phone_number(self, request, phone):
        if phone is None:
            raise NotFound
        phone = self._normalize_phone(phone)

        user = User.objects.filter(phone=phone).first()
        if user is None:
            raise NotFound

        if request.user is not None:
            raise ParseError  # 400

        request.user = user
        request.save()

    def _normalize_phone(self, phone):
        result = '+'
        for char in phone:
            if '0' <= char <= '9':
                result += char
        return result
