import cars.settings
from cars.core.push_client import CarsharingPushClientLogger
from cars.django.lock import UwsgiLock


class CallcenterPushClientLogger(CarsharingPushClientLogger):

    def __init__(self, filename):
        super().__init__(filename=filename, lock=UwsgiLock())

    def log(self, type_, data):
        type_ = 'callcenter.{}'.format(type_)
        super().log(type_=type_, data=data)


PUSH_CLIENT = CallcenterPushClientLogger(filename=cars.settings.CALLCENTER['push_client']['filename'])
