from cars.core.daemons import CarsharingDaemon

from ..core.call_priority_manager import CallPriorityManager


class CallPriorityDaemon(CarsharingDaemon):

    tick_interval = '* * * * * */15'  # every 15 secs

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self.call_priority_manager = CallPriorityManager.from_settings()

    def get_distributed_lock_relative_path(self):
        return 'carsharing/locks/call_priority_daemon.lock'

    def get_solomon_sensor_prefix(self):
        return 'callcenter.call_priority_daemon'

    def get_solomon_service(self):
        return 'callcenter'

    def _do_tick(self):
        self.call_priority_manager.add_call_priority()


class CallPrioritySyncDaemon(CarsharingDaemon):

    tick_interval = '*/10 * * * *'  # every 10 minutes

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self.call_priority_manager = CallPriorityManager.from_settings()

    def get_distributed_lock_relative_path(self):
        return 'carsharing/locks/call_priority_sync_daemon.lock'

    def get_solomon_sensor_prefix(self):
        return 'callcenter.call_priority_sync_daemon'

    def get_solomon_service(self):
        return 'callcenter'

    def _do_tick(self):
        self.call_priority_manager.delete_call_priority()
        self.call_priority_manager.sync_call_priority()
