# Generated by Django 2.0.3 on 2019-01-11 16:10

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import phonenumber_field.modelfields


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('callcenter', '0014_add_refusion_date'),
    ]

    operations = [
        migrations.CreateModel(
            name='CallCenterBlacklistedPhone',
            fields=[
                ('entry_id', models.AutoField(primary_key=True, serialize=False)),
                ('phone', phonenumber_field.modelfields.PhoneNumberField(max_length=128)),
                ('blocked_until', models.DateTimeField(null=True)),
                ('comment', models.TextField(default='')),
            ],
            options={
                'db_table': 'call_center_blacklisted_phone',
            },
        ),
        migrations.CreateModel(
            name='CallCenterBlacklistedPhoneHistory',
            fields=[
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_action', models.CharField(choices=[('add', 'ADD'), ('remove', 'REMOVE'), ('update_data', 'UPDATE_DATA')], max_length=1)),
                ('history_timestamp', models.DateTimeField()),
                ('entry_id', models.IntegerField()),
                ('phone', phonenumber_field.modelfields.PhoneNumberField(max_length=128)),
                ('blocked_until', models.DateTimeField(null=True)),
                ('comment', models.TextField(default='')),
                ('history_user_id', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'call_center_blacklisted_phone_history',
            },
        ),
        migrations.AddIndex(
            model_name='callcenterblacklistedphone',
            index=models.Index(fields=['phone'], name='call_center_blacklisted_phone_phone_idx'),
        ),
        migrations.AddIndex(
            model_name='callcenterblacklistedphonehistory',
            index=models.Index(fields=['entry_id'], name='call_center_blacklisted_phone_history_entry_id_idx'),
        ),
    ]
