import enum

from django.db import models
from django.utils import timezone
from phonenumber_field.modelfields import PhoneNumberField

from cars.users.models import User


class CallAssignmentCallCenter(enum.Enum):
    AudioTele = 'audiotele'
    Beeper = 'beeper'
    NextContact = 'nextcontact'
    Yandex = 'yandex'


class CallAssignment(models.Model):
    from_number = PhoneNumberField()

    # work phone cannot be interpreted as ordinary phone
    # may be null to store intermediate result
    to_number = models.IntegerField(null=True)

    from_user = models.ForeignKey(
        User,
        related_name='outgoing_call_assignments',
        on_delete=models.SET_NULL,
        null=True,
    )

    to_user = models.ForeignKey(
        User,
        related_name='incoming_call_assignments',
        on_delete=models.SET_NULL,
        null=True,
    )

    added_at = models.DateTimeField(default=timezone.now)
    connected_at = models.DateTimeField(null=True)
    reported_at = models.DateTimeField(null=True)

    call_id = models.CharField(max_length=64, null=True)  # call center call id

    call_center = models.CharField(max_length=16, null=True)

    queue = models.CharField(max_length=64, null=True)  # call center queue

    class Meta:
        db_table = 'call_assignment'

    def __str__(self):
        return ('<CallAssignment: from_number={}, to_number={}, added={}>'
                .format(self.from_number, self.to_number, self.added_at))
