from django.db import models

from cars.users.models import User


class CallCenterSettings(models.Model):
    setting_key = models.TextField(primary_key=True)
    setting_value = models.TextField()

    class Meta:
        db_table = 'call_center_settings'


class CallCenterSettingsHistory(models.Model):
    history_event_id = models.AutoField(primary_key=True)
    history_user = models.ForeignKey(
        User,
        on_delete=models.CASCADE,
        related_name='call_center_settings_history_history_user'
    )
    history_action = models.TextField()
    history_timestamp = models.IntegerField()

    setting_key = models.TextField()
    setting_value = models.TextField()

    class Meta:
        db_table = 'call_center_settings_history'
