from django.db import models

from cars.users.models import User


class CallPriorityUser(models.Model):
    user = models.OneToOneField(
        User,
        related_name='call_priority',
        on_delete=models.CASCADE,
        null=False,
        primary_key=True
    )
    added_at = models.DateTimeField(auto_now_add=True, null=False)

    class Meta:
        db_table = 'call_priority_user'


class CallPrioritySyncTime(models.Model):
    time = models.DateTimeField(null=False)

    class Meta:
        db_table = 'call_priority_sync_time'
