from django.db import models

from phonenumber_field.modelfields import PhoneNumberField

from cars.users.models import User


class CallCenterBlacklistedPhone(models.Model):
    entry_id = models.AutoField(primary_key=True)

    phone = PhoneNumberField(unique=True)

    blocked_until = models.DateTimeField(null=True)

    comment = models.TextField(default='')

    class Meta:
        db_table = 'call_center_blacklisted_phone'
        indexes = [
            models.Index(
                fields=['phone'],
                name='call_center_blacklisted_phone_phone_idx',
            ),
        ]


class CallCenterBlacklistedPhoneHistory(models.Model):
    history_id = models.AutoField(primary_key=True)

    history_user = models.ForeignKey(
        User,
        on_delete=models.SET_NULL,
        null=True,
    )

    history_action = models.CharField(max_length=20)

    history_timestamp = models.DateTimeField()

    entry_id = models.IntegerField()

    phone = PhoneNumberField()

    blocked_until = models.DateTimeField(null=True)

    comment = models.TextField(default='')

    class Meta:
        db_table = 'call_center_blacklisted_phone_history'
