import uuid
from django.db import models

from cars.users.models import User


class CallcenterUserLink(models.Model):

    id = models.UUIDField(default=uuid.uuid4, primary_key=True)

    user = models.ForeignKey(
        User,
        related_name='callcenter_requests',
        on_delete=models.CASCADE,
        null=True,
    )

    requester = models.ForeignKey(
        User,
        related_name='callcenter_answers',
        on_delete=models.CASCADE,
    )

    created_at = models.DateTimeField()
    available_until = models.DateTimeField()

    class Meta:
        db_table = 'callcenter_user_link'
