from rest_framework.serializers import ModelSerializer

from cars.carsharing.models import Car, CarLocation, CarModel
from cars.carsharing.models.car_telematics_state import CarTelematicsState


class CallcenterCarLocationSerializer(ModelSerializer):

    class Meta:
        model = CarLocation
        fields = [
            'lat',
            'lon',
        ]


class CallcenterCarModelSerializer(ModelSerializer):

    class Meta:
        model = CarModel
        fields = [
            'code',
            'manufacturer',
            'name',
        ]


class CallcenterCarTelematicsStateSerializer(ModelSerializer):

    class Meta:
        model = CarTelematicsState
        fields = [
            'fuel_level',
            'front_left_door_open',
            'front_right_door_open',
            'rear_left_door_open',
            'rear_right_door_open',
        ]


class CallcenterCarSerializer(ModelSerializer):

    model = CallcenterCarModelSerializer()
    location = CallcenterCarLocationSerializer()
    telematics_state = CallcenterCarTelematicsStateSerializer()

    class Meta:
        model = Car
        fields = [
            'id',
            'number',
            'model',
            'status',
            'location',
            'telematics_state',
            'fuel_card_number',
        ]
