from rest_framework.serializers import ModelSerializer

from cars.django.serializers import TimestampField
from cars.carsharing.models import CarsharingReservation, CarsharingRide, CarsharingParking
from cars.orders.models import Order, OrderItem
from .car import CallcenterCarSerializer


class CallcenterCarsharingReservationSerializer(ModelSerializer):
    car = CallcenterCarSerializer()

    class Meta:
        model = CarsharingReservation
        fields = [
            'car'
        ]


class CallcenterCarsharingRideSerializer(ModelSerializer):
    car = CallcenterCarSerializer()

    class Meta:
        model = CarsharingRide
        fields = [
            'car'
        ]


class CallcenterCarsharingParkingSerializer(ModelSerializer):
    car = CallcenterCarSerializer()

    class Meta:
        model = CarsharingParking
        fields = [
            'car'
        ]


class CallcenterOrderItemSerializer(ModelSerializer):
    started_at = TimestampField()
    finished_at = TimestampField()

    carsharing_reservation = CallcenterCarsharingReservationSerializer()
    carsharing_ride = CallcenterCarsharingReservationSerializer()
    carsharing_parking = CallcenterCarsharingReservationSerializer()

    class Meta:
        model = OrderItem
        fields = [
            'id',
            'started_at',
            'finished_at',
            'type',
            'carsharing_reservation',
            'carsharing_ride',
            'carsharing_parking',
        ]


class CallcenterOrderSerializer(ModelSerializer):
    items = CallcenterOrderItemSerializer(many=True)
    created_at = TimestampField()
    completed_at = TimestampField()

    class Meta:
        model = Order
        fields = [
            'id',
            'items',
            'created_at',
            'completed_at',
        ]
