from django.conf.urls import url

from . import views
from cars.django.views import GoneView


app_name = 'callcenter'
urlpatterns = [
    url(
        r'^(?P<call_id>[\w-]+)/car-commands/close/$',
        GoneView.as_view(),  # views.CloseCarCommandView.as_view(),
        name='car-command-close'
    ),
    url(
        r'^(?P<call_id>[\w-]+)/car-commands/open/$',
        GoneView.as_view(),  # views.OpenCarCommandView.as_view(),
        name='car-command-open'
    ),
    url(
        r'^(?P<call_id>[\w-]+)/car-commands/unlock-hood/$',
        GoneView.as_view(),  # views.UnlockHoodCommandView.as_view(),
        name='car-command-unlock-hood'
    ),
    url(
        r'^(?P<call_id>[\w-]+)/car-commands/lock-hood/$',
        GoneView.as_view(),  # views.LockHoodCommandView.as_view(),
        name='car-command-lock-hood'
    ),
    url(
        r'^(?P<call_id>[\w-]+)/car-commands/start-lease/$',
        GoneView.as_view(),  # views.StartLeaseCommandView.as_view(),
        name='car-command-start-lease'
    ),
    url(
        r'^(?P<call_id>[\w-]+)/car-commands/end-lease/$',
        GoneView.as_view(),  # views.EndLeaseCommandView.as_view(),
        name='car-command-end-lease'
    ),
    url(
        r'^(?P<call_id>[\w-]+)/fuel-card/$',
        GoneView.as_view(),  # views.UpdateFuelCardNumberView.as_view(),
        name='car-update-fuel-card'
    ),
    url(
        r'^(?P<call_id>[\w-]+)/fuel-card/activate/$',
        GoneView.as_view(),  # views.FuelCardActivateView.as_view(),
        name='car-activate-fuel-card',
    ),
    url(
        r'^(?P<call_id>[\w-]+)/fuel-card/block/$',
        GoneView.as_view(),  # views.FuelCardBlockView.as_view(),
        name='car-block-fuel-card',
    ),
    url(
        r'^(?P<call_id>[\w-]+)/user/$',
        GoneView.as_view(),  # views.UserDetailsView.as_view(),
        name='user-details'
    ),
    url(
        r'^(?P<call_id>[\w-]+)/user/request-phone-verification/$',
        GoneView.as_view(),  # views.UserRequestPhoneVerificationView.as_view(),
        name='user-request-phone-verification',
    ),
    url(
        r'^(?P<call_id>[\w-]+)/order/finish/$',
        GoneView.as_view(),  # views.OrderFinishView.as_view(),
        name='finish-current-order'
    ),
    url(
        r'^(?P<call_id>[\w-]+)/phone/$',
        GoneView.as_view(),  # views.CallcenterRegisterPhoneView.as_view(),
        name='enter-user-phone',
    ),
    url(
        r'^user-link-request/$',
        GoneView.as_view(),  # views.CallcenterRequestView.as_view(),
        name='user-link-request'
    ),
]
