from django.shortcuts import get_object_or_404
from rest_framework.response import Response
from rest_framework.status import HTTP_400_BAD_REQUEST

from cars.orders.core.order_manager import OrderManager
from cars.orders.models import Order
from ..core.push_client import PUSH_CLIENT
from ..models import CallcenterUserLink
from ..serializers.user import CallcenterUserSerializer
from .base import CallcenterAPIView


class OrderFinishView(CallcenterAPIView):

    manager = OrderManager.from_settings(push_client=PUSH_CLIENT)

    def do_post(self, request, call_id):  # pylint: disable=unused-argument
        user = get_object_or_404(CallcenterUserLink, id=call_id).user
        active_order = (
            Order.objects.filter(
                user=user,
                completed_at__isnull=True,
            )
            .first()
        )

        if active_order is None:
            return Response(status=HTTP_400_BAD_REQUEST)

        self.manager.force_complete_order(active_order)
        user = get_object_or_404(CallcenterUserLink, id=call_id).user
        return Response(
            CallcenterUserSerializer(user, context=self.get_serializer_context()).data
        )
