from django.shortcuts import get_object_or_404
from rest_framework.response import Response
from rest_framework.status import HTTP_400_BAD_REQUEST

from cars.users.core import UserProfileUpdater
from ..models import CallcenterUserLink
from ..serializers import CallcenterUserSerializer
from .base import CallcenterAPIView


class UserDetailsView(CallcenterAPIView):

    serializer_class = CallcenterUserSerializer

    def do_get(self, request, call_id):  # pylint: disable=unused-argument
        user = get_object_or_404(CallcenterUserLink, id=call_id).user
        if user is None:
            return Response(status=HTTP_400_BAD_REQUEST)

        return Response(self.serializer_class(user, context=self.get_serializer_context()).data)


class UserRequestPhoneVerificationView(CallcenterAPIView):

    serializer_class = CallcenterUserSerializer

    def do_post(self, request, call_id):  # pylint: disable=unused-argument
        user = get_object_or_404(CallcenterUserLink, id=call_id).user

        updater = UserProfileUpdater(user=user)
        updater.request_phone_verification(request.user.id)
        user.refresh_from_db()
        return Response(
            self.serializer_class(user, context=self.get_serializer_context()).data
        )
