import copy


class UserPropsGetter:

    PORSCHE_TAG = 'porsche'
    PLUS_TAG = 'plus'

    def __init__(self, user, car):
        self._car = car
        self._user = user

    def get_props(self):
        result = copy.deepcopy(self._user.tags or [])
        result += self._get_porsche_props()
        result += self._get_user_status_props()
        result += self._get_plus_props()

        return result

    def _get_porsche_props(self):
        is_riding_porsche = self._car is not None and self._car.model.manufacturer == 'Porsche'
        return [self.PORSCHE_TAG] if is_riding_porsche else []

    def _get_user_status_props(self):
        return [self._user.status]

    def _get_plus_props(self):
        return [self.PLUS_TAG] if self._user.get_plus_status() else []
