from django.conf.urls import url

from . import views
from cars.django.views import GoneView


app_name = 'callcenter_internal'
urlpatterns = [
    url(
        r'^(?P<phone_number>[\w-]+)/car-commands/close/$',
        GoneView.as_view(),  # views.CloseCarCommandView.as_view(),
        name='car-command-close'
    ),
    url(
        r'^(?P<phone_number>[\w-]+)/car-commands/open/$',
        GoneView.as_view(),  # views.OpenCarCommandView.as_view(),
        name='car-command-open'
    ),
    url(
        r'^(?P<phone_number>[\w-]+)/car-commands/unlock-hood/$',
        GoneView.as_view(),  # views.UnlockHoodCommandView.as_view(),
        name='car-command-unlock-hood'
    ),
    url(
        r'^(?P<phone_number>[\w-]+)/car-commands/lock-hood/$',
        GoneView.as_view(),  # views.LockHoodCommandView.as_view(),
        name='car-command-lock-hood'
    ),
    url(
        r'^(?P<phone_number>[\w-]+)/car-commands/start-lease/$',
        GoneView.as_view(),  # views.StartLeaseCommandView.as_view(),
        name='car-command-start-lease'
    ),
    url(
        r'^(?P<phone_number>[\w-]+)/car-commands/end-lease/$',
        GoneView.as_view(),  # views.EndLeaseCommandView.as_view(),
        name='car-command-end-lease'
    ),
    url(
        r'^(?P<phone_number>[\w-]+)/fuel-card/$',
        GoneView.as_view(),  # views.UpdateFuelCardNumberView.as_view(),
        name='car-update-fuel-card'
    ),
    url(
        r'^(?P<phone_number>[\w-]+)/fuel-card/activate/$',
        GoneView.as_view(),  # views.FuelCardActivateView.as_view(),
        name='car-activate-fuel-card',
    ),
    url(
        r'^(?P<phone_number>[\w-]+)/fuel-card/block/$',
        GoneView.as_view(),  # views.FuelCardBlockView.as_view(),
        name='car-block-fuel-card',
    ),
    url(
        r'^(?P<phone_number>[\w-]+)/user/$',
        GoneView.as_view(),  # views.UserDetailsView.as_view(),
        name='user-details'
    ),
    url(
        r'^(?P<phone_number>[\w-]+)/user-props/$',
        GoneView.as_view(),  # views.UserPropsView.as_view(),
        name='user-props',
    ),
    url(
        r'^(?P<phone_number>[\w-]+)/user/request-phone-verification/$',
        GoneView.as_view(),  # views.UserRequestPhoneVerificationView.as_view(),
        name='user-request-phone-verification'
    ),
    url(
        r'^(?P<phone_number>[\w-]+)/order/finish/$',
        GoneView.as_view(),  # views.OrderFinishView.as_view(),
        name='finish-current-order'
    ),
]
