from rest_framework.response import Response
from rest_framework.status import HTTP_400_BAD_REQUEST

from cars.orders.core.order_manager import OrderManager
from cars.callcenter.core.push_client import PUSH_CLIENT
from cars.callcenter.serializers.user import CallcenterUserSerializer
from cars.users.models import User
from .base import CallcenterInternalAPIView


class OrderFinishView(CallcenterInternalAPIView):

    manager = OrderManager.from_settings(push_client=PUSH_CLIENT)

    def do_post(self, request, *args, **kwargs):  # pylint: disable=unused-argument
        if self.order is None:
            return Response(
                {
                    'error': 'order.missing',
                },
                status=HTTP_400_BAD_REQUEST,
            )

        if self.order.completed_at is not None:
            return Response(
                {
                    'error': 'order.inactive',
                },
                status=HTTP_400_BAD_REQUEST,
            )

        self.manager.force_complete_order(self.order)
        user = User.objects.get(id=self.user.id)
        return Response(
            CallcenterUserSerializer(user, context=self.get_serializer_context()).data
        )
