from rest_framework.response import Response

from cars.admin.permissions import AdminPermissionCode, AdminPermissionFactory
from cars.callcenter.serializers import CallcenterUserSerializer
from cars.callcenter_internal.core.props_getter import UserPropsGetter
from cars.users.core import UserProfileUpdater
from cars.users.models import User
from .base import CallcenterInternalAPIView


class UserDetailsView(CallcenterInternalAPIView):

    serializer_class = CallcenterUserSerializer

    permission_classes = [AdminPermissionFactory.build(AdminPermissionCode.VIEW_USER)]

    def do_get(self, request, *args, **kwargs):  # pylint: disable=unused-argument
        return Response(
            self.serializer_class(self.user, context=self.get_serializer_context()).data
        )


class UserRequestPhoneVerificationView(CallcenterInternalAPIView):

    serializer_class = CallcenterUserSerializer

    permission_classes = [AdminPermissionFactory.build(AdminPermissionCode.VIEW_USER)]

    def do_post(self, request, *args, **kwargs):  # pylint: disable=unused-argument
        updater = UserProfileUpdater(user=self.user)
        updater.request_phone_verification(request.user.id)
        self.user.refresh_from_db()
        return Response(
            self.serializer_class(self.user, context=self.get_serializer_context()).data
        )


class UserPropsView(CallcenterInternalAPIView):

    permission_classes = [AdminPermissionFactory.build(AdminPermissionCode.VIEW_USER)]

    queryset = User

    def do_get(self, request, *args, **kwargs):  # pylint:disable=unused-argument
        props_getter = UserPropsGetter(
            user=self.user,
            car=self.car
        )

        return Response(
            props_getter.get_props()
        )
