# -*- coding: utf-8 -*-

from django.db import models


class CarDocument(models.Model):
    id = models.UUIDField(primary_key=True)
    type = models.TextField()
    added_at = models.BigIntegerField()
    added_by_id = models.UUIDField()
    car_hardware_beacon_id = models.UUIDField(null=True)
    car_hardware_sim_id = models.UUIDField(null=True)
    car_hardware_vega_id = models.UUIDField(null=True)
    car_hardware_head_id = models.UUIDField(null=True)
    car_hardware_modem_id = models.UUIDField(null=True)
    car_registry_document_id = models.UUIDField(null=True)
    car_insurance_policy_id = models.IntegerField(null=True)

    class Meta:
        managed = False
        db_table = 'car_document'


class CarDocumentAssignment(models.Model):
    id = models.UUIDField(primary_key=True)
    assigned_at = models.BigIntegerField()
    unassigned_at = models.BigIntegerField(null=True)
    assigned_by_id = models.UUIDField()
    unassigned_by_id = models.UUIDField(null=True)
    car_id = models.UUIDField()
    document_id = models.UUIDField()

    class Meta:
        managed = False
        db_table = 'car_document_assignment'


class CarDocumentHistory(models.Model):
    history_event_id = models.IntegerField(primary_key=True, null=False)
    history_user_id = models.CharField(max_length=36, null=False)
    history_action = models.TextField(null=False)
    history_timestamp = models.IntegerField(null=False)
    history_comment = models.TextField(null=True)
    history_originator_id = models.UUIDField(null=True)
    id = models.UUIDField(null=False)
    type = models.CharField(max_length=32, null=False)
    added_at = models.BigIntegerField(null=False)
    added_by_id = models.UUIDField(null=True)
    car_hardware_beacon_id = models.UUIDField(null=True)
    car_hardware_sim_id = models.UUIDField(null=True)
    car_hardware_vega_id = models.UUIDField(null=True)
    car_hardware_head_id = models.UUIDField(null=True)
    car_hardware_modem_id = models.UUIDField(null=True)
    car_registry_document_id = models.UUIDField(null=True)
    car_insurance_policy_id = models.IntegerField(null=True)
    blob = models.TextField(null=True)
    modified_at = models.BigIntegerField(null=True)

    class Meta:
        managed = False
        db_table = 'drive_car_document_history'


class CarDocumentAssignmentHistory(models.Model):
    history_event_id = models.IntegerField(primary_key=True, null=False)
    history_user_id = models.CharField(max_length=36, null=False)
    history_action = models.TextField(null=False)
    history_timestamp = models.IntegerField(null=False)
    history_comment = models.TextField(null=True)
    history_originator_id = models.UUIDField(null=True)
    id = models.UUIDField(null=False)
    assigned_at = models.BigIntegerField(null=True)
    unassigned_at = models.BigIntegerField(null=True)
    assigned_by_id = models.UUIDField(null=True)
    unassigned_by_id = models.UUIDField(null=True)
    car_id = models.UUIDField(null=True)
    document_id = models.UUIDField(null=True)

    class Meta:
        managed = False
        db_table = 'drive_car_document_assignment_history'
