# -*- coding: utf-8 -*-

from django.db import models


class CarHardwareHead(models.Model):
    id = models.UUIDField(primary_key=True)
    head_id = models.TextField()
    device_id = models.TextField(null=True)

    class Meta:
        managed = False
        db_table = 'car_hardware_head'


class CarHardwareVega(models.Model):
    id = models.UUIDField(primary_key=True)
    imei = models.BigIntegerField()
    primary_sim_id = models.UUIDField(null=True)
    secondary_sim_id = models.UUIDField(null=True)

    class Meta:
        managed = False
        db_table = 'car_hardware_vega'
