# -*- coding: utf-8 -*-

from django.db import models
from cars.users.models import User


class CarTagHistory(models.Model):
    history_event_id = models.BigIntegerField(primary_key=True)
    history_user = models.ForeignKey(
        User,
        on_delete=models.CASCADE,
    )
    history_action = models.TextField()
    history_timestamp = models.BigIntegerField()
    history_comment = models.TextField(null=True)
    tag = models.TextField(null=True)
    tag_id = models.UUIDField(null=True)
    object_id = models.UUIDField()
    data = models.TextField(null=True)
    performer = models.TextField(null=True)
    priority = models.IntegerField(null=True)
    snapshot = models.TextField(null=True)
    history_originator_id = models.TextField(null=True)

    class Meta:
        managed = False
        db_table = 'car_tags_history'
