from django.contrib import admin

from cars.admin.permissions import AdminPermissionCode
from .models.car import Car


class CarAdmin(admin.ModelAdmin):
    list_display = ['number', 'vin', 'imei', 'registration_id']
    search_fields = ['number', 'vin', 'imei', 'registration_id']
    fields = ['id', 'number', 'vin', 'imei', 'registration_id']
    readonly_fields = ['id', 'vin']

    change_permission = AdminPermissionCode.get_full_code(AdminPermissionCode.OPERATE_CARS)

    def has_change_permission(self, request, obj=None):
        return request.user.has_perm(self.change_permission)


admin.site.register(Car, CarAdmin)
