"""
Segments are planned to be moved to SaaS backend in one month.

Here's a cheap prototype for new features. It's nothing but just a temporary solution.
"""

import cars.settings


class CarsharingSegmentsManagerPrototype:

    def __init__(self, car):
        self._car = car
        self._model = car.model

    def has_night_waiting(self):
        return self._model.manufacturer != 'Porsche'

    def get_night_parking_cost(self):
        return 0

    def get_night_waiting_interval(self, timestamp, is_plus_user):
        if not self.has_night_waiting():
            return None, None

        end_of_night_waiting = 2 * 60 * 60 + 1800  # UTC offset
        if is_plus_user:
            end_of_night_waiting += 1800

        seconds_since_beginning_of_day = timestamp % 86400
        day_start = timestamp // 86400 * 86400
        if seconds_since_beginning_of_day < end_of_night_waiting:
            # it's night waiting right now, after midnight
            start = day_start - 1800 - 60 * 60 * 3  # 23:30, also count UTC offset
            end = day_start + end_of_night_waiting
            return start, end

        # night waiting starts this day, in the evening
        day_start += 86400
        start = day_start - 1800 - 60 * 60 * 3  # 23:30, also count UTC offset
        end = day_start + end_of_night_waiting
        return start, end

    def is_night_waiting_active(self, timestamp, is_plus_user):
        start, end = self.get_night_waiting_interval(timestamp, is_plus_user)
        return start <= timestamp <= end

    @staticmethod
    def filter_cars_list(cars_list, user):
        tags = user.tags or []
        audi_tags = [
            'silver_client',
            'gold_client',
            'platinum_client',
            'yandex_staff',
            'yandex_stuff',
        ]
        tags_for_models = cars.settings.SEGMENTS['tags_for_models']

        result = []
        for car in cars_list:
            model_code = car['model']['code']
            if model_code in ('audi_a3', 'audi_q3'):
                show = False
                for tag in audi_tags:
                    if tag in tags:
                        show = True
                        break
                if not show:
                    continue

            if model_code in tags_for_models:
                required_tag = tags_for_models[model_code]
                if required_tag not in tags:
                    # user doesn't have the required tag
                    continue
            result.append(car)

        return result
