import enum


class WialonParameter(object):

    def __init__(self, code, db_column, allow_zeros=True):
        self.code = code
        self.db_column = db_column
        self.allow_zeros = allow_zeros

    def __str__(self):
        return '<WialonParameter: code={}, db_column={}>'.format(self.code, self.db_column)

    @property
    def updated_at_db_column(self):
        return '{}_updated_at'.format(self.db_column)


class WialonParameters(enum.Enum):
    MCU_FIRMWARE = WialonParameter(code=2, db_column='mcu_firmware')

    EXT_VOLTAGE = WialonParameter(code=1252, db_column='ext_voltage')
    ACC_VOLTAGE = WialonParameter(code=1253, db_column='acc_voltage')
    ACC_CHARGE = WialonParameter(code=1255, db_column='acc_charge')

    MILEAGE = WialonParameter(code=2103, db_column='mileage', allow_zeros=False)

    FUEL_LEVEL = WialonParameter(code=2107, db_column='fuel_level', allow_zeros=False)

    ENGINE_TEMPERATURE = WialonParameter(code=2110, db_column='engine_temperature')

    OIL_CHECK_ON = WialonParameter(code=2152, db_column='oil_check_on')
    HAND_BRAKE_CHECK_ON = WialonParameter(code=2154, db_column='hand_brake_check_on')
    BATTERY_CHECK_ON = WialonParameter(code=2155, db_column='baterry_check_on')
    AIRBAG_CHECK_ON = WialonParameter(code=2156, db_column='airbag_check_on')
    INFLATION_PRESSURE_CHECK_ON = WialonParameter(
        code=2159,
        db_column='inflation_pressure_check_on',
    )
    BRAKE_CHECK_ON = WialonParameter(code=2160, db_column='brake_check_on')
    FUEL_LEVEL_CHECK_ON = WialonParameter(code=2163, db_column='fuel_level_check_on')
    SERVICE_MAINTENANCE_CHECK_ON = WialonParameter(
        code=2164,
        db_column='service_maintenance_check_on',
    )

    DIPPED_BEAM_ON = WialonParameter(code=2170, db_column='dipped_beam_on')
    MAIN_BEAM_ON = WialonParameter(code=2171, db_column='main_beam_on')

    DRIVER_BELT_FASTENED = WialonParameter(code=2173, db_column='driver_belt_fastened')

    IGNITION_ON = WialonParameter(code=2202, db_column='ignition_on')

    TRANSMISSION_SELECTOR_PARK = WialonParameter(code=2208, db_column='transmission_selector_park')

    HAND_BRAKE_ON = WialonParameter(code=2209, db_column='hand_brake_on')
    PEDAL_BRAKE_ON = WialonParameter(code=2210, db_column='pedal_brake_on')

    ENGINE_ON = WialonParameter(code=2211, db_column='engine_on')

    FRONT_LEFT_DOOR_OPEN = WialonParameter(code=2213, db_column='front_left_door_open')
    FRONT_RIGHT_DOOR_OPEN = WialonParameter(code=2214, db_column='front_right_door_open')
    REAR_LEFT_DOOR_OPEN = WialonParameter(code=2215, db_column='rear_left_door_open')
    REAR_RIGHT_DOOR_OPEN = WialonParameter(code=2216, db_column='rear_right_door_open')

    HOOD_OPEN = WialonParameter(code=2217, db_column='hood_open')
    TRUNK_OPEN = WialonParameter(code=2218, db_column='trunk_open')
