from factory import Sequence, RelatedFactory, SubFactory
from factory.django import DjangoModelFactory
from factory.fuzzy import FuzzyText

from ..models.car import Car
from .car_insurance import CarInsuranceFactory
from .car_location import CarLocationFactory
from .car_model import CarModelFactory
from .car_telematics_state import CarTelematicsStateFactory


class CarFactory(DjangoModelFactory):

    class Meta:
        model = Car

    imei = Sequence(lambda n: n)
    location = RelatedFactory(CarLocationFactory, 'car')
    model = SubFactory(CarModelFactory)
    number = FuzzyText(length=9)
    status = Car.Status.AVAILABLE.value

    fuel_card_number = FuzzyText(length=15)

    insurance = RelatedFactory(CarInsuranceFactory, 'car')

    telematics_state = RelatedFactory(CarTelematicsStateFactory, 'car')
