from factory.django import DjangoModelFactory
from factory.fuzzy import FuzzyDecimal, FuzzyText

from ..models.car_insurance import CarInsurance


class CarInsuranceFactory(DjangoModelFactory):
    base_cost = FuzzyDecimal(low=0.1, high=1, precision=2)
    per_minute_cost = FuzzyDecimal(low=0.1, high=1, precision=2)
    agreement_number = FuzzyText()
    agreement_partner_number = FuzzyText()

    class Meta:
        model = CarInsurance
