from django.utils import timezone

from factory import LazyAttribute
from factory.django import DjangoModelFactory
from factory.fuzzy import FuzzyFloat

from ..models.car_location import CarLocation


class CarLocationFactory(DjangoModelFactory):

    class Meta:
        model = CarLocation

    updated_at = LazyAttribute(lambda _: timezone.now())
    lat = FuzzyFloat(55.702036, 55.790343)
    lon = FuzzyFloat(37.527009, 37.708284)
