import pytz
from string import digits
import time
from uuid import uuid4

from factory import LazyAttribute, LazyFunction, SelfAttribute, SubFactory
from factory.django import DjangoModelFactory
from factory.fuzzy import FuzzyText, FuzzyDecimal, FuzzyDecimal, FuzzyDate, FuzzyDateTime

from cars.carsharing.factories.car import CarFactory
from cars.users.factories.user import UserFactory
from cars.orders.factories.order import OrderFactory


from factory import LazyAttribute, RelatedFactory, Sequence, SubFactory
from factory.django import DjangoModelFactory
from factory.fuzzy import FuzzyText

from ..models.car_tags_history import CarTagsHistory


class CarTagsHistoryFactory(DjangoModelFactory):

    class Meta:
        model = CarTagsHistory
        exclude = ['_object']

    _object = SubFactory(CarFactory)
    history_event_id = FuzzyDecimal(10**6)
    object_id = LazyAttribute(lambda o: o._object.id)
    history_timestamp = int(time.time()) - 3600
    tag_id = LazyFunction(uuid4)
