from factory import SubFactory
from factory.django import DjangoModelFactory
from factory.fuzzy import FuzzyInteger

from ..models.reservation import CarsharingReservation
from .car import CarFactory


class CarsharingReservationFactory(DjangoModelFactory):

    class Meta:
        model = CarsharingReservation

    car = SubFactory(CarFactory)
    max_duration_seconds = FuzzyInteger(low=10, high=30)
