# -*- coding: utf-8 -*-
# Generated by Django 1.11.6 on 2017-12-24 17:31
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Car',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('imei', models.BigIntegerField(unique=True)),
                ('number', models.CharField(max_length=16, unique=True)),
                ('status', models.CharField(choices=[('available', 'AVAILABLE'), ('reservation', 'RESERVATION'), ('ride', 'RIDE'), ('service', 'SERVICE')], default='service', max_length=16)),
            ],
            options={
                'db_table': 'car',
            },
        ),
        migrations.CreateModel(
            name='CarLocation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('updated_at', models.DateTimeField()),
                ('lat', models.FloatField()),
                ('lon', models.FloatField()),
                ('car', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='location', to='carsharing.Car')),
            ],
            options={
                'db_table': 'car_location',
            },
        ),
        migrations.CreateModel(
            name='CarModel',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(choices=[('KIA Rio', 'KIA Rio'), ('KIA Rio X-Line', 'KIA Rio X-Line'), ('Renault Captur', 'Renault Captur')], max_length=64)),
                ('manufacturer', models.CharField(choices=[('KIA', 'KIA'), ('Renault', 'Renault')], max_length=64)),
            ],
            options={
                'db_table': 'car_model',
            },
        ),
        migrations.CreateModel(
            name='CarTelematics',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=64)),
            ],
            options={
                'db_table': 'car_telematics',
            },
        ),
        migrations.CreateModel(
            name='CarTelematicsState',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('car', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='telematics_state', to='carsharing.Car')),
                ('telematics', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='car_states', to='carsharing.CarTelematics')),
            ],
            options={
                'db_table': 'car_telematics_state',
            },
        ),
        migrations.AddField(
            model_name='car',
            name='model',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='carsharing.CarModel'),
        ),
        migrations.AddIndex(
            model_name='car',
            index=models.Index(fields=['status'], name='car_status_idx'),
        ),
    ]
