# -*- coding: utf-8 -*-
# Generated by Django 1.11.3 on 2018-01-24 17:08
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('carsharing', '0011_car_insurance_agreement_number'),
    ]

    operations = [
        migrations.CreateModel(
            name='AutocodeFine',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('ruling_number', models.CharField(max_length=64, unique=True)),
                ('autocode_id', models.BigIntegerField(unique=True)),
                ('autocode_payment_confirmation_id', models.BigIntegerField(null=True, unique=True)),
                ('violation_date', models.DateField()),
                ('ruling_date', models.DateField()),
                ('discount_date', models.DateField(null=True)),
                ('article_koap', models.TextField()),
                ('violation_place', models.TextField()),
                ('sum_to_pay', models.DecimalField(decimal_places=2, max_digits=9)),
                ('odps_code', models.CharField(max_length=16)),
                ('odps_name', models.TextField()),
                ('violation_document_number', models.CharField(max_length=16)),
                ('violation_document_type', models.CharField(choices=[('DriverLicense', 'DRIVER_LICENSE'), ('Sts', 'STS')], max_length=13)),
                ('has_photo', models.BooleanField()),
                ('fine_information_received_at', models.DateTimeField()),
                ('payment_confirmation_received_at', models.DateTimeField(null=True)),
                ('car', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='autocode_fines', to='carsharing.Car')),
                ('user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='autocode_fines', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'autocode_fine',
            },
        ),
    ]
