# Generated by Django 2.0.3 on 2018-04-05 01:47

from django.db import migrations, models
import django.db.models.deletion
import phonenumber_field.modelfields
import uuid


class Migration(migrations.Migration):

    dependencies = [
        ('carsharing', '0031_ride_mileage_columns'),
    ]

    operations = [
        migrations.CreateModel(
            name='CarHardwareBeacon',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('imei', models.BigIntegerField(unique=True)),
            ],
            options={
                'db_table': 'car_hardware_beacon',
            },
        ),
        migrations.CreateModel(
            name='CarHardwareSim',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('phone_number', phonenumber_field.modelfields.PhoneNumberField(max_length=128, unique=True)),
                ('icc', models.BigIntegerField()),
            ],
            options={
                'db_table': 'car_hardware_sim',
            },
        ),
        migrations.CreateModel(
            name='CarHardwareVega',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('imei', models.BigIntegerField(unique=True)),
                ('primary_sim', models.OneToOneField(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='vega_primary_sim', to='carsharing.CarHardwareSim')),
                ('secondary_sim', models.OneToOneField(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='vega_secondary_sim', to='carsharing.CarHardwareSim')),
            ],
            options={
                'db_table': 'car_hardware_vega',
            },
        ),
        migrations.AddField(
            model_name='carhardwarebeacon',
            name='sim',
            field=models.OneToOneField(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='beacon', to='carsharing.CarHardwareSim'),
        ),
    ]
