# Generated by Django 2.0.3 on 2018-04-05 22:06

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django_db_constraints.operations
import uuid


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('carsharing', '0033_make_sim_icc_uniqie'),
    ]

    operations = [
        migrations.CreateModel(
            name='CarDocument',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('type', models.CharField(choices=[('car_hardware_beacon', 'CAR_HARDWARE_BEACON'), ('car_hardware_sim', 'CAR_HARDWARE_SIM'), ('car_hardware_vega', 'CAR_HARDWARE_VEGA')], max_length=32)),
                ('added_at', models.DateTimeField()),
                ('added_by', models.ForeignKey(db_index=False, on_delete=django.db.models.deletion.CASCADE, related_name='car_documents_added', to=settings.AUTH_USER_MODEL)),
                ('car_hardware_beacon', models.OneToOneField(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='car_document', to='carsharing.CarHardwareBeacon')),
                ('car_hardware_sim', models.OneToOneField(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='car_document', to='carsharing.CarHardwareSim')),
                ('car_hardware_vega', models.OneToOneField(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='car_document', to='carsharing.CarHardwareVega')),
            ],
            options={
                'db_table': 'car_document',
            },
        ),
        django_db_constraints.operations.AlterConstraints(
            name='CarDocument',
            db_constraints={'exclusive_arc_chk': "\n                CHECK (\n                  (\n                    (type = 'car_hardware_beacon' AND car_hardware_beacon_id IS NOT NULL)\n                    OR\n                    (type = 'car_hardware_sim' AND car_hardware_sim_id IS NOT NULL)\n                    OR\n                    (type = 'car_hardware_vega' AND car_hardware_vega_id IS NOT NULL)\n                  )\n                  AND\n                  (\n                    CASE WHEN car_hardware_beacon_id IS NOT NULL THEN 1 ELSE 0 END\n                    +\n                    CASE WHEN car_hardware_sim_id IS NOT NULL THEN 1 ELSE 0 END\n                    +\n                    CASE WHEN car_hardware_vega_id IS NOT NULL THEN 1 ELSE 0 END\n                  ) = 1\n                )\n                "},
        ),
    ]
