# Generated by Django 2.0.3 on 2018-04-11 00:55

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django_db_constraints.operations
import uuid


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('carsharing', '0037_car_assembly_photo_thumbnail_link'),
    ]

    operations = [
        migrations.CreateModel(
            name='CarDocumentAssignment',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('assigned_at', models.DateTimeField()),
                ('unassigned_at', models.DateTimeField(null=True)),
                ('assigned_by', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='document_assignments', to=settings.AUTH_USER_MODEL)),
                ('car', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='document_assignments', to='carsharing.Car')),
            ],
            options={
                'db_table': 'car_document_assignment',
            },
        ),
        migrations.CreateModel(
            name='CarHardwareHead',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('head_id', models.CharField(max_length=64)),
                ('device_id', models.CharField(max_length=64, null=True)),
            ],
            options={
                'db_table': 'car_hardware_head',
            },
        ),
        migrations.CreateModel(
            name='CarHardwareModem',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('sim', models.OneToOneField(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='modem', to='carsharing.CarHardwareSim')),
            ],
            options={
                'db_table': 'car_hardware_modem',
            },
        ),
        migrations.AlterField(
            model_name='cardocument',
            name='type',
            field=models.CharField(choices=[('car_hardware_beacon', 'CAR_HARDWARE_BEACON'), ('car_hardware_head', 'CAR_HARDWARE_HEAD'), ('car_hardware_modem', 'CAR_HARDWARE_MODEM'), ('car_hardware_sim', 'CAR_HARDWARE_SIM'), ('car_hardware_vega', 'CAR_HARDWARE_VEGA')], max_length=32),
        ),
        migrations.AddField(
            model_name='cardocumentassignment',
            name='document',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='assignments', to='carsharing.CarDocument'),
        ),
        migrations.AddField(
            model_name='cardocumentassignment',
            name='unassigned_by',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='document_unassignments', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='cardocument',
            name='car_hardware_head',
            field=models.OneToOneField(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='car_document', to='carsharing.CarHardwareHead'),
        ),
        migrations.AddField(
            model_name='cardocument',
            name='car_hardware_modem',
            field=models.OneToOneField(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='car_document', to='carsharing.CarHardwareModem'),
        ),
        django_db_constraints.operations.AlterConstraints(
            name='cardocument',
            db_constraints={'exclusive_arc_chk': "\n                CHECK (\n                  (\n                    (type = 'car_hardware_beacon' AND car_hardware_beacon_id IS NOT NULL)\n                    OR\n                    (type = 'car_hardware_head' AND car_hardware_head_id IS NOT NULL)\n                    OR\n                    (type = 'car_hardware_modem' AND car_hardware_modem_id IS NOT NULL)\n                    OR\n                    (type = 'car_hardware_sim' AND car_hardware_sim_id IS NOT NULL)\n                    OR\n                    (type = 'car_hardware_vega' AND car_hardware_vega_id IS NOT NULL)\n                  )\n                  AND\n                  (\n                    CASE WHEN car_hardware_beacon_id IS NOT NULL THEN 1 ELSE 0 END\n                    +\n                    CASE WHEN car_hardware_head_id IS NOT NULL THEN 1 ELSE 0 END\n                    +\n                    CASE WHEN car_hardware_modem_id IS NOT NULL THEN 1 ELSE 0 END\n                    +\n                    CASE WHEN car_hardware_sim_id IS NOT NULL THEN 1 ELSE 0 END\n                    +\n                    CASE WHEN car_hardware_vega_id IS NOT NULL THEN 1 ELSE 0 END\n                  ) = 1\n                )\n                "},
        ),
    ]
