# Generated by Django 2.0.3 on 2018-04-11 14:41

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('carsharing', '0038_car_document_assignment'),
    ]

    operations = [
        migrations.CreateModel(
            name='CarsharingTariffPlan',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=128, unique=True)),
                ('created_at', models.DateTimeField()),
                ('user_tag', models.CharField(max_length=128, null=True)),
                ('car_model', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='carsharing.CarModel')),
                ('created_by', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'carsharing_tariff_plan',
            },
        ),
        migrations.CreateModel(
            name='CarsharingTariffPlanEntry',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('day_of_week', models.PositiveSmallIntegerField(null=True)),
                ('start_time', models.TimeField(null=True)),
                ('end_time', models.TimeField(null=True)),
                ('parking_cost_per_minute', models.DecimalField(decimal_places=2, max_digits=10)),
                ('ride_cost_per_minute', models.DecimalField(decimal_places=2, max_digits=10)),
                ('tariff_plan', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='entries', to='carsharing.CarsharingTariffPlan')),
            ],
            options={
                'db_table': 'carsharing_tariff_plan_entry',
            },
        ),
    ]
