# Generated by Django 2.0.3 on 2018-04-17 00:52

from django.db import migrations, models
import django.db.models.deletion
import django_db_constraints.operations
import uuid


class Migration(migrations.Migration):

    dependencies = [
        ('carsharing', '0040_car_imei_and_number_not_needed_on_creation'),
    ]

    operations = [
        migrations.CreateModel(
            name='CarRegistryDocument',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('contract_id', models.CharField(max_length=32, null=True)),
                ('registration_id', models.BigIntegerField(null=True)),
                ('registration_date', models.DateTimeField(null=True)),
                ('fuel_card_number', models.CharField(max_length=18, null=True)),
                ('number', models.CharField(max_length=16, null=True)),
                ('imei', models.BigIntegerField(null=True)),
                ('contract_date', models.DateTimeField(null=True)),
                ('transfer_date', models.DateTimeField(null=True)),
                ('casco_number', models.CharField(max_length=16, null=True)),
                ('osago_number', models.CharField(max_length=16, null=True)),
                ('osago_date', models.DateTimeField(null=True)),
                ('mark_by_pts', models.CharField(max_length=16, null=True)),
                ('production_year', models.IntegerField(null=True)),
                ('pts_number', models.CharField(max_length=16, null=True)),
                ('antitheft_system', models.CharField(max_length=64, null=True)),
                ('number_of_keys', models.IntegerField(null=True)),
                ('parking_permit_start_date', models.DateTimeField(null=True)),
                ('deptrans_documents_date', models.DateTimeField(null=True)),
            ],
            options={
                'db_table': 'car_registry_document',
            },
        ),
        migrations.AlterField(
            model_name='cardocument',
            name='type',
            field=models.CharField(choices=[('car_hardware_beacon', 'CAR_HARDWARE_BEACON'), ('car_hardware_head', 'CAR_HARDWARE_HEAD'), ('car_hardware_modem', 'CAR_HARDWARE_MODEM'), ('car_hardware_sim', 'CAR_HARDWARE_SIM'), ('car_hardware_vega', 'CAR_HARDWARE_VEGA'), ('car_registry_document', 'CAR_REGISTRY_DOCUMENT')], max_length=32),
        ),
        migrations.AddField(
            model_name='cardocument',
            name='car_registry_document',
            field=models.OneToOneField(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='car_document', to='carsharing.CarRegistryDocument'),
        ),
        django_db_constraints.operations.AlterConstraints(
            name='cardocument',
            db_constraints={'exclusive_arc_chk': "\n                CHECK (\n                  (\n                    (type = 'car_hardware_beacon' AND car_hardware_beacon_id IS NOT NULL)\n                    OR\n                    (type = 'car_hardware_head' AND car_hardware_head_id IS NOT NULL)\n                    OR\n                    (type = 'car_hardware_modem' AND car_hardware_modem_id IS NOT NULL)\n                    OR\n                    (type = 'car_hardware_sim' AND car_hardware_sim_id IS NOT NULL)\n                    OR\n                    (type = 'car_hardware_vega' AND car_hardware_vega_id IS NOT NULL)\n                    OR\n                    (type = 'car_registry_document' AND car_registry_document_id IS NOT NULL)\n                  )\n                  AND\n                  (\n                    CASE WHEN car_hardware_beacon_id IS NOT NULL THEN 1 ELSE 0 END\n                    +\n                    CASE WHEN car_hardware_head_id IS NOT NULL THEN 1 ELSE 0 END\n                    +\n                    CASE WHEN car_hardware_modem_id IS NOT NULL THEN 1 ELSE 0 END\n                    +\n                    CASE WHEN car_hardware_sim_id IS NOT NULL THEN 1 ELSE 0 END\n                    +\n                    CASE WHEN car_hardware_vega_id IS NOT NULL THEN 1 ELSE 0 END\n                    +\n                    CASE WHEN car_registry_document_id IS NOT NULL THEN 1 ELSE 0 END\n                  ) = 1\n                )\n                "},
        ),
    ]
